#!/usr/local/bin/perl

# This script transforms 'lexems' file into 'lexems.inc' & 'lexems.hpp' files.
# 'lexems' file should contain lines in format shown below:
# lexem, lid
# where lexem is the name of lexem (e.g. SysopName) and lid is the suffix of
# the identifier for this lexem (e.g. SYSOP_NAME). In this case full identifier
# name will be LID_SYSOP_NAME.
# Script writes 'lexems.inc' file placing lid constants and sorted lexems array
# there.

# Sample:
# perl lexems.pl cfg_lexems CfgLexems.hpp CfgLexems.inc CFG_LEXEM_ Cfg

$argc = @ARGV;
if ($argc != 5) {
	print "Usage: lexems.pl <source> <dest> <include> <prefix1> <prefix2>\n";
	exit 0;
}

$source  = $ARGV[0];
$dest    = $ARGV[1];
$include = $ARGV[2];
$prefix1 = $ARGV[3];
$prefix2 = $ARGV[4];
$prefix3 = $ARGV[5];

open( IN, $source ) || die("Failed to open \'$source\' file.\n");

$line = <IN>;
while ($line ne "") {
	chop($line);

       	($lexem, $lid) = split( /\,/, $line );

       	$lexem =~ s/\s+$//;
       	$lid   =~ s/^\s+//;

       	if ($lexem ne "" && $lid ne "") {
       		$lexems{$lexem} = $lid;
       	}
	$line = <IN>;
}

close( IN );

open( OUT, ">$dest") || die("Failed to open \'$dest\' file.\n");

print OUT "#ifndef __".$prefix1."_HEADER__\n";
print OUT "#define __".$prefix1."_HEADER__\n\n";

$i = 0;
foreach $lexem (sort(keys(%lexems))) {
	print OUT "const int\011$prefix1$lexems{$lexem} = $i;\n";
	$i++;
}

print OUT "\nint\011get".$prefix2."LexemID(LPCTSTR szLexem);\n\n";
print OUT "#endif\n";

close( OUT );

open( OUT, ">$include") || die("Failed to open \'$include\' file.\n");

print OUT "LPCTSTR\011$prefix2"."Lexems[] = {\n";
foreach $lexem (sort(keys(%lexems))) {
	print OUT "\011_T(\"$lexem\"),\n";
}
print OUT "};\n";

close( OUT );
